/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: VARANApp_Functionlist.h $
   Last Modification:
    $Author: Dimitar $
    $Modtime: 10.03.06 18:51 $
    $Revision: 10 $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    VARAN App
    Task function list for configuration file
       
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
        
**************************************************************************************/
/**
 * @file VARANApp_Functionlist.h
 * @brief VARAN App - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_VARANApp</code>
 * of task.
 */
#ifndef __VARAN_APP_FUNCTIONLIST_H
#define __VARAN_APP_FUNCTIONLIST_H


#define RCX_PROT_CLASS_VARAN      0x0027

/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_VARANApp
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_VARANApp
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);
                                             
TLR_VOID
TaskEnter_VARANApp
(
 TLR_VOID FAR* pvInit
);


/** version of task startup parameter */
#define VARAN_APP_STARTUP_PARAM_VERSION   (1)


/** task startup parameter */
typedef struct VARAN_APP_STARTUPPARAMETER_Ttag  VARAN_APP_STARTUPPARAMETER_T;

/** task status leds parameters */
typedef struct VARAN_APP_LED_CONFIG_Ttag  VARAN_APP_LED_CONFIG_T;


/** Varan Client Application default parameters */
/** Default DPM channel  */
#define VARAN_APP_DEFAULT_CHANNEL_0               (0)

#define VARAN_APP_DEFAULT_RED_LED_NAME            "VRS_RED"
#define VARAN_APP_DEFAULT_RED_LED_INST            (0)

#define VARAN_APP_DEFAULT_GREEN_LED_NAME          "VRS_GREEN"
#define VARAN_APP_DEFAULT_GREEN_LED_INST          (0)

#define TLR_TASK_VARAN_APP            (0x009D0000)

/** status led type */
struct VARAN_APP_LED_CONFIG_Ttag
{
  STRING      szName[16];   /** Name of the LED */
  TLR_UINT32  ulLedInst;    /** Instance of the LED*/
};

/* task startup parameter */
struct VARAN_APP_STARTUPPARAMETER_Ttag
{
  TLR_TASK_PARAMETERHEADER;
  TLR_UINT32 ulDPMChannel;
  TLR_BOOLEAN fEnabled;
  TLR_VOID *pvStartuPck;
  VARAN_APP_LED_CONFIG_T tRedLed;
  VARAN_APP_LED_CONFIG_T tGreenLed;
};


/*
***************************************************************
*  Default Copy&Past Configuration Example of Varan Client Task
***************************************************************
*/
//#if (defined ENABLE_VARAN_CLIENT_APP)
//STATIC CONST VARAN_APP_STARTUPPARAMETER_T tVaranAppStartUpPrm[] = {
//  {
//    TLR_TASK_VARAN_APP,                   /* ulTaskIdentifier (TLR_TASK_PARAMETERHEADER)*/
//    VARAN_APP_STARTUP_PARAM_VERSION,      /* ulParamVersion (TLR_TASK_PARAMETERHEADER)  */
//    VARAN_APP_DEFAULT_CHANNEL_0,          /* DPM Channel to run on */
//    0,                                    /* Reserved. should be set to 0 */
//    NULL,                                 /* Reserved. should be set to NULL */
//    {VARAN_APP_DEFAULT_RED_LED_NAME, VARAN_APP_DEFAULT_RED_LED_INST},
//    {VARAN_APP_DEFAULT_GREEN_LED_NAME, VARAN_APP_DEFAULT_GREEN_LED_INST},
//  },
//};
//#endif

#define VARAN_CLIENT_APP_TASK_NAME          "VARANApp"
#define VARAN_CLIENT_APP_TASK_INSTANCE      (VARAN_APP_DEFAULT_CHANNEL_0)
#define VARAN_CLIENT_APP_STACK_SIZE         (2048)


//#if (defined ENABLE_VARAN_CLIENT_APP)
//   {VARAN_CLIENT_APP_TASK_NAME,           /* Set Identification */
//    TSK_PRIO_51, TSK_TOK_51,              /* Set Priority,and Token ID */
//    VARAN_CLIENT_APP_TASK_INSTANCE,       /* Set Instance to 0 */
//    NULL,                                 /* Pointer to Stack */
//    VARAN_CLIENT_APP_STACK_SIZE,          /* Size of Task Stack */
//    0,                                    /* Threshold to maximum possible value */
//    RX_TASK_AUTO_START,                   /* Start task automatically */
//    (void FAR*)TaskEnter_VARANApp,        /* Task function to schedule */
//    (void*)TaskExit_VARANApp,             /* Function called when Task will be deleted */
//    (UINT32)&tVaranAppStartUpPrm[0],      /* Startup Parameter */
//    {0,0,0,0,0,0,0,0}                     /* Reserved Region */
//   },
//#endif


/** @} */


/*************************************************************************************/
#endif /* #ifndef __VARAN_APP_FUNCTIONLIST_H */
